// TrybyKartyGrafDlg.cpp : implementation file
//

#include "stdafx.h"
#include "TrybyKartyGraf.h"
#include "TrybyKartyGrafDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CTrybyKartyGrafDlg dialog

#include <exception>

bool CTrybyKartyGrafDlg::CzyWinNT()
{
   OSVERSIONINFO osInfo;
   osInfo.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);

   if(GetVersionEx(&osInfo) == 0)
   {
      throw std::exception("Nie udao si pobra informacji o systemie");
   }

   return osInfo.dwPlatformId == VER_PLATFORM_WIN32_NT;
}

CString CTrybyKartyGrafDlg::PrzygotujOpisTrybuKartyGraf(int i,DEVMODE* pTrybKartyGraf)
{
		CString opis;
		wchar_t pozycja[5]={L'\0'};
		_itow_s(i,pozycja,5,10);
		opis.Append(pozycja);
		opis.Append(L". ");
		wchar_t szerokoscEkranu[5]={L'\0'};
		_itow_s(pTrybKartyGraf->dmPelsWidth,szerokoscEkranu,5,10);
		opis.Append(szerokoscEkranu);
		opis.Append(L" x ");
		wchar_t wysokoscEkranu[5]={L'\0'};
		_itow_s(pTrybKartyGraf->dmPelsHeight,wysokoscEkranu,5,10);
		opis.Append(wysokoscEkranu);
		opis.Append(L", ");
		if(CzyWinNT())
		{
			wchar_t czestoscOdswiezania[5]={L'\0'};
			_itow_s(pTrybKartyGraf->dmDisplayFrequency,czestoscOdswiezania,5,10);
			opis.Append(czestoscOdswiezania);
			opis.Append(L"Hz, ");
		}
		wchar_t bity[3]={L'\0'};
		_itow_s(pTrybKartyGraf->dmBitsPerPel,bity,3,10);
		opis.Append(bity);
		opis.Append(L" bitow (");

		switch(pTrybKartyGraf->dmBitsPerPel)
		{
			case 1: opis.Append(L"Monochromatyczny"); break;
			case 2: opis.Append(L"4 kolory"); break;
			case 4: opis.Append(L"16 kolorw"); break;
			case 8: opis.Append(L"256 kolorw"); break;
			case 16: opis.Append(L"High color"); break;
			case 32: opis.Append(L"True color"); break;
			default: opis.Append(L"Nierozpoznana ilo kolorw"); break;
		}
		
		opis.Append(L"), obraz obrcony o ");
		
		switch(pTrybKartyGraf->dmDisplayOrientation)
		{
			case DMDO_DEFAULT: opis.Append(L"0"); break;
			case DMDO_90: opis.Append(L"90"); break;
			case DMDO_180: opis.Append(L"180"); break;
			case DMDO_270: opis.Append(L"270"); break;
		}
		
		opis.Append(L" stopni");

		return opis;
}

void CTrybyKartyGrafDlg::TworzListeTrybowKartyGraf()
{
	int i=0;
	bool wynik=true;
	while(wynik)
	{		

		DEVMODE* pTrybKartyGraf=new DEVMODE;
		wynik=EnumDisplaySettings(NULL,i,pTrybKartyGraf)!=0;
		if(!wynik) break;

		listaTrybowKartyGraf->AddTail(pTrybKartyGraf);

		if(i==0)
		{
			CString tekst(L"Dostpne tryby wywietlania na ");
			tekst.Append(pTrybKartyGraf->dmDeviceName);
			edit1.SetWindowText(tekst);
		}

		CString opis=PrzygotujOpisTrybuKartyGraf(i,pTrybKartyGraf);

		listBox1.AddString(opis);
		i++;
	}
}

void CTrybyKartyGrafDlg::BiezacyTrybKartyGraf()
{
	DEVMODE aktualnyTrybKartyGraf;
	EnumDisplaySettings(NULL,ENUM_CURRENT_SETTINGS,&aktualnyTrybKartyGraf);
	edit2.SetWindowTextW(PrzygotujOpisTrybuKartyGraf(0,&aktualnyTrybKartyGraf));

	int iloscTrybowKartyGraf=listaTrybowKartyGraf->GetCount();
	int iloscTrafien=0;

	int i=0;
	for( POSITION pos = listaTrybowKartyGraf->GetHeadPosition(); pos != NULL; listaTrybowKartyGraf->GetNext( pos ) )
    {        
		DEVMODE* pTrybKartyGraf=listaTrybowKartyGraf->GetAt(pos);
		if(aktualnyTrybKartyGraf.dmBitsPerPel==pTrybKartyGraf->dmBitsPerPel &&
		   aktualnyTrybKartyGraf.dmPelsWidth==pTrybKartyGraf->dmPelsWidth &&
		   aktualnyTrybKartyGraf.dmPelsHeight==pTrybKartyGraf->dmPelsHeight &&
		   aktualnyTrybKartyGraf.dmDisplayFrequency==pTrybKartyGraf->dmDisplayFrequency &&
		   aktualnyTrybKartyGraf.dmDisplayOrientation==pTrybKartyGraf->dmDisplayOrientation)
		{
			listBox1.SetCurSel(i);
			break;
		}
		++i;
    }
}

CTrybyKartyGrafDlg::CTrybyKartyGrafDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CTrybyKartyGrafDlg::IDD, pParent),listaTrybowKartyGraf(new CList<DEVMODE*>)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);	
}

void CTrybyKartyGrafDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDIT1, edit1);
	DDX_Control(pDX, IDC_LIST1, listBox1);
	DDX_Control(pDX, IDC_EDIT2, edit2);
}

BEGIN_MESSAGE_MAP(CTrybyKartyGrafDlg, CDialog)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_BUTTON1, &CTrybyKartyGrafDlg::OnBnClickedButton1)
END_MESSAGE_MAP()


// CTrybyKartyGrafDlg message handlers

BOOL CTrybyKartyGrafDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	TworzListeTrybowKartyGraf();
	BiezacyTrybKartyGraf();

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CTrybyKartyGrafDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CTrybyKartyGrafDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

void CTrybyKartyGrafDlg::OnBnClickedButton1()
{
	int pozycjaNaLiscie=listBox1.GetCurSel();
	POSITION pozycja=listaTrybowKartyGraf->GetHeadPosition();
	for(int i=0;i<pozycjaNaLiscie;++i) listaTrybowKartyGraf->GetNext(pozycja);
	LONG wynik=ChangeDisplaySettings(listaTrybowKartyGraf->GetAt(pozycja),0);
	if(wynik==DISP_CHANGE_SUCCESSFUL) BiezacyTrybKartyGraf();
	else 
	{
		MessageBeep(MB_ICONHAND);
		CString s;
		switch(wynik)
		{
			case DISP_CHANGE_SUCCESSFUL: s.Append(L"Tryb wywietlania zosta zmieniony");break;
			case DISP_CHANGE_RESTART: s.Append(L"Niezbdne jest ponowne uruchomienie komputera");break;
			case DISP_CHANGE_BADFLAGS: s.Append(L"Bdne ustawienia");break;
			case DISP_CHANGE_FAILED: s.Append(L"Sterownik ekranu odrzuci ustawienia");break;
			case DISP_CHANGE_BADMODE: s.Append(L"Wybrany tryb ekranu nie jest obdugiwany");break;
			case DISP_CHANGE_NOTUPDATED: s.Append(L"Nowe ustawienia nie mogy zosta zapisane do rejestru(brak uprawnie)");break;
			default: s.Append(L"ChangeDisplaySettings: Efekt nierozpoznany");break;
		}
		MessageBox(s);
	}
}
